define(['./_baseHasIn', './_hasPath'], function(baseHasIn, hasPath) {

  'use strict';

  /**
   * Checks if `path` is a direct or inherited property of `object`.
   *
   * @static
   * @memberOf _
   * @category Object
   * @param {Object} object The object to query.
   * @param {Array|string} path The path to check.
   * @returns {boolean} Returns `true` if `path` exists, else `false`.
   * @example
   *
   * var object = _.create({ 'a': _.create({ 'b': _.create({ 'c': 3 }) }) });
   *
   * _.hasIn(object, 'a');
   * // => true
   *
   * _.hasIn(object, 'a.b.c');
   * // => true
   *
   * _.hasIn(object, ['a', 'b', 'c']);
   * // => true
   *
   * _.hasIn(object, 'b');
   * // => false
   */
  function hasIn(object, path) {
    return hasPath(object, path, baseHasIn);
  }

  return hasIn;
});
